

source("utils.R")


# Assume that you have 2 dataframes : 
#   
#   1) df ( consists of F, X1, ... , X6, A, Y )
#   2) W  (consists pf X*, F) : X* is transformed covariates.

#### Simulated Datasets are located in "simulated_data" folder.
#### You can choose datasets you want. 

df = readRDS("simulated_data/T1_n2000_df.rds")
W = readRDS("simulated_data/T1_n2000_W.rds")

### PARAMETER SETTING ##########################
lambda = 1; delta = .05; delta_prime = 20;
w.max = 1; w.min = 0; M = 1e4;
################################################

### IPW based grouping

# IPW_method(df, W)

### Optimization based grouping

# Weight.via.Opt(df, W, method, ...)


### Visualization

## PLOT 1 (FAIRNESS DISTRIBUTION)
# let 'result' be a output of IPW_method or Weight.via.Opt function
# fairness_vis(result$finaldf)

## PLOT 2,3 (Covariate Balance for each subgroup)
# covbal_vis(result, subgroup index, lowerbound of quantile, upperbound of quantile)

IPW = IPW_method(df = df, W = W)
fairness_vis(IPW$finaldf)  
covbal_vis(IPW, subgroup.no = 1, lb = 0.05, ub = 0.95)
covbal_vis(IPW, subgroup.no = 2, lb = 0.05, ub = 0.95)


MeanOpt = Weight.via.Opt(df = df, W = W, method = "mean", 
                         lambda = lambda, delta = delta,
                         delta_prime = delta_prime,
                         w.max = w.max, w.min= w.min,
                         M= 1e4)
fairness_vis(MeanOpt$finaldf)  
covbal_vis(MeanOpt, subgroup.no = 1, lb = 0.1, ub = 0.9)
covbal_vis(MeanOpt, subgroup.no = 2, lb = 0.1, ub = 0.9)


KR50opt = Weight.via.Opt(df = df, W = W, method = "KR50",
                                   lambda = lambda, delta = delta,
                                   delta_prime = delta_prime,
                                   w.max = w.max, w.min= w.min,
                                   M= 1e4)
fairness_vis(KR50opt$finaldf)  
covbal_vis(KR50opt, subgroup.no = 1, lb = 0.1, ub = 0.9)
covbal_vis(KR50opt, subgroup.no = 2, lb = 0.1, ub = 0.9)


KR100opt = Weight.via.Opt(df = df, W = W, method = "KR100",
                                    lambda = lambda, delta = delta,
                                    delta_prime = delta_prime,
                                    w.max = w.max, w.min= w.min,
                                    M= 1e4)
fairness_vis(KR100opt$finaldf)  
covbal_vis(KR100opt, subgroup.no = 1, lb = 0.1, ub = 0.9)
covbal_vis(KR100opt, subgroup.no = 2, lb = 0.05, ub = 0.95)





